/*
 * COPYRIGHT (c) 2010 by Institute of Computer Science, 
 * Foundation for Research and Technology - Hellas
 * Contact: 
 *      POBox 1385, Heraklio Crete, GR-700 13 GREECE
 *      Tel:+30-2810-391632
 *      Fax: +30-2810-391638
 *      E-mail: isl@ics.forth.gr
 *      http://www.ics.forth.gr/isl/cci.html
 * 
 * This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 
 * Unported License (http://creativecommons.org/licenses/by-sa/3.0/)
*/

package gui;

/**
 *
 * Gui class
 * @author Koutraki Maria (kutraki@ics.forth.gr)
 */

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;
import Transformation.*;


public class Gui extends javax.swing.JFrame {

    private JFileChooser chosenFile = null;
    private JFileChooser chosenFile2 = null;
    private JFileChooser chosenFile3 = null;
    private String file = null;
    private String file2 = null;
    private String path = null;
    private parserOfLidoFile domPars2;
    private parserOfMapping domPars;

    /** Creates new form Gui */
    public Gui() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        inputMappingPanel = new javax.swing.JPanel();
        mappingField = new javax.swing.JTextField();
        Browse = new javax.swing.JButton();
        inputMuseumdatPanel = new javax.swing.JPanel();
        museumdatField = new javax.swing.JTextField();
        Browse2 = new javax.swing.JButton();
        Convertion = new javax.swing.JButton();
        destinationPath = new javax.swing.JPanel();
        destinationPathFiled = new javax.swing.JTextField();
        Browse3 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("XML2RDF Data Transformation Tool");
        setLocationByPlatform(true);

        inputMappingPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Input Data Transformation Mapping file"));

        mappingField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mappingFieldActionPerformed(evt);
            }
        });

        Browse.setText("Browse");
        Browse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BrowseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout inputMappingPanelLayout = new javax.swing.GroupLayout(inputMappingPanel);
        inputMappingPanel.setLayout(inputMappingPanelLayout);
        inputMappingPanelLayout.setHorizontalGroup(
            inputMappingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, inputMappingPanelLayout.createSequentialGroup()
                .addComponent(mappingField, javax.swing.GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(Browse, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        inputMappingPanelLayout.setVerticalGroup(
            inputMappingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inputMappingPanelLayout.createSequentialGroup()
                .addGroup(inputMappingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mappingField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(Browse))
                .addContainerGap(19, Short.MAX_VALUE))
        );

        inputMuseumdatPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Input source XML file"));

        museumdatField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                museumdatFieldActionPerformed(evt);
            }
        });

        Browse2.setText("Browse");
        Browse2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Browse2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout inputMuseumdatPanelLayout = new javax.swing.GroupLayout(inputMuseumdatPanel);
        inputMuseumdatPanel.setLayout(inputMuseumdatPanelLayout);
        inputMuseumdatPanelLayout.setHorizontalGroup(
            inputMuseumdatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inputMuseumdatPanelLayout.createSequentialGroup()
                .addComponent(museumdatField, javax.swing.GroupLayout.PREFERRED_SIZE, 303, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(Browse2, javax.swing.GroupLayout.DEFAULT_SIZE, 81, Short.MAX_VALUE)
                .addContainerGap())
        );
        inputMuseumdatPanelLayout.setVerticalGroup(
            inputMuseumdatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inputMuseumdatPanelLayout.createSequentialGroup()
                .addGroup(inputMuseumdatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(museumdatField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(Browse2))
                .addContainerGap(23, Short.MAX_VALUE))
        );

        Convertion.setText("Convertion");
        Convertion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ConvertionActionPerformed(evt);
            }
        });

        destinationPath.setBorder(javax.swing.BorderFactory.createTitledBorder("Destination Path for RDF file"));

        destinationPathFiled.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                destinationPathFiledActionPerformed(evt);
            }
        });

        Browse3.setText("Browse");
        Browse3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Browse3ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout destinationPathLayout = new javax.swing.GroupLayout(destinationPath);
        destinationPath.setLayout(destinationPathLayout);
        destinationPathLayout.setHorizontalGroup(
            destinationPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(destinationPathLayout.createSequentialGroup()
                .addComponent(destinationPathFiled, javax.swing.GroupLayout.PREFERRED_SIZE, 303, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(Browse3, javax.swing.GroupLayout.DEFAULT_SIZE, 81, Short.MAX_VALUE)
                .addContainerGap())
        );
        destinationPathLayout.setVerticalGroup(
            destinationPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(destinationPathLayout.createSequentialGroup()
                .addGroup(destinationPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(destinationPathFiled, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(Browse3))
                .addContainerGap(23, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(inputMuseumdatPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(inputMappingPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(Convertion)
                        .addGap(172, 172, 172))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(destinationPath, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(inputMappingPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(inputMuseumdatPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(destinationPath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE)
                .addComponent(Convertion, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void mappingFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mappingFieldActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_mappingFieldActionPerformed

    private void BrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BrowseActionPerformed
        // TODO add your handling code here:
        int value = JFileChooser.CANCEL_OPTION;
        if (chosenFile == null) {
            chosenFile = new JFileChooser();
            FileFilter filter = new FileFilter() {

                public boolean accept(File f) {
                    if ((f == null) || (f.getName() == null)) {
                        return false;
                    }

                    if ((f.getName().endsWith(".xml")) || (f.isDirectory())) {
                        return true;
                    }

                    return false;
                }

                public String getDescription() {
                    return "file (*.xml)";
                }
            };
            chosenFile.setFileFilter(filter);
        }
        value = chosenFile.showOpenDialog(new JPanel());
        file = null;
        if (value == JFileChooser.APPROVE_OPTION) {
            file = chosenFile.getSelectedFile().toString();
            mappingField.setText(file);
            domPars = new parserOfMapping();
            try {
                try {
                    domPars.parsing(new File(file));
                } catch (ParserConfigurationException ex) {
                    Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
                } catch (SAXException ex) {
                    Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
                }
            } catch (XPathExpressionException ex) {
                Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
            }
        }


}//GEN-LAST:event_BrowseActionPerformed

    private void museumdatFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_museumdatFieldActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_museumdatFieldActionPerformed

    private void Browse2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Browse2ActionPerformed
        // TODO add your handling code here:
        int value = JFileChooser.CANCEL_OPTION;
        if (chosenFile2 == null) {
            chosenFile2 = new JFileChooser();
            FileFilter filter = new FileFilter() {

                public boolean accept(File f) {
                    if ((f == null) || (f.getName() == null)) {
                        return false;
                    }

                    if ((f.getName().endsWith(".xml")) || (f.isDirectory())) {
                        return true;
                    }

                    return false;
                }

                public String getDescription() {
                    return "file (*.xml)";
                }
            };
            chosenFile2.setFileFilter(filter);
        }
        value = chosenFile2.showOpenDialog(new JPanel());
        file2 = null;
        if (value == JFileChooser.APPROVE_OPTION) {
            file2 = chosenFile2.getSelectedFile().toString();
            museumdatField.setText(file2);
            domPars2 = new parserOfLidoFile(domPars, file2);
        }
}//GEN-LAST:event_Browse2ActionPerformed

    private void ConvertionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ConvertionActionPerformed
        try {
            domPars2.transform(domPars, file2, path);
        } catch (IOException ex) {
            Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
        }
            JOptionPane.showMessageDialog(this, "Successfully converted XML file to RDF.", "Convertion finnished", JOptionPane.INFORMATION_MESSAGE);
       
}//GEN-LAST:event_ConvertionActionPerformed

    private void destinationPathFiledActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_destinationPathFiledActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_destinationPathFiledActionPerformed

    private void Browse3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Browse3ActionPerformed
        int value = JFileChooser.CANCEL_OPTION;
        if (chosenFile3 == null) {
            chosenFile3 = new JFileChooser();
            chosenFile3.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY );
            FileFilter filter = new FileFilter() {

                public boolean accept(File f) {
                    if ((f == null) || (f.getPath() == null)) {
                        return false;
                    }

                    if ((f.isDirectory())) {
                        return true;
                    }

                    return false;
                }

                public String getDescription() {
                    return "folder";
                }
            };
            chosenFile3.setFileFilter(filter);
        }
        value = chosenFile3.showOpenDialog(new JPanel());
        path = null;
        if (value == JFileChooser.APPROVE_OPTION) {
            path = chosenFile3.getSelectedFile().toString();
            destinationPathFiled.setText(path);
        }
    // TODO add your handling code here:
    }//GEN-LAST:event_Browse3ActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton Browse;
    private javax.swing.JButton Browse2;
    private javax.swing.JButton Browse3;
    private javax.swing.JButton Convertion;
    private javax.swing.JPanel destinationPath;
    private javax.swing.JTextField destinationPathFiled;
    private javax.swing.JPanel inputMappingPanel;
    private javax.swing.JPanel inputMuseumdatPanel;
    private javax.swing.JTextField mappingField;
    private javax.swing.JTextField museumdatField;
    // End of variables declaration//GEN-END:variables
}
